import { View, Text, FlatList, BackHandler } from "react-native";
import React from "react";
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import { ProfileStyles } from "../ProfileStyle";
import { orderHistoryStyle } from "./OrderHistoryStyle";
import { useDispatch, useSelector } from "react-redux";
import useAuth from "../../../hooks/useAuth";
import {
    getMoreOrders,
    getMyOrders,
} from "../../../redux/slices/user/orderHistory/getOrderHistory";
import OrderHistorySkeleton from "../../../src/skeletons/screens/profile/order/OrderHistorySkeleton";
import EmptyContent from "../../Utilities/EmptyContent/EmptyContent";
import NoContentIcon from "../../../assets/svgs/empty content/noAddress.svg";
import { useRef } from "react";
import { useState } from "react";
import SingleOrder from "./SingleOrder";

import { BASE_API_URL_STG } from "@env";
import { useMemo } from "react";
import CustomActiveIndicator from "../../../src/components/CustomLoader/CustomActiveIndicator";
import { getPreferences } from "../../../redux/slices/preferences/getPreferences";
import DownArrowFill from "../../../assets/svgs/downArrowFill.svg";
import SelectInput from "../../../src/components/CustomInput/SelectInput/SelectInput";
import SelectItemBottomSheet from "../../../src/components/SelectItemBottomSheet/SelectItemBottomSheet";
import { useEffect } from "react";
import useLangTranslation from "../../../hooks/useLangTranslation";
import usePreferences from "../../../hooks/usePreferences";
import { txtSliceFmt } from "../../../helper/txtSliceFmt";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";
import { getCountries } from "../../../redux/slices/user/address/getCountries";
import { getAllOrderStatus } from "../../../redux/slices/trackOrder/getAllStatus";

const OrderHistory = (props) => {
    const { trans } = useLangTranslation();

    const dateFilter = [
        { name: trans("All Time"), value: "" },
        { name: trans("Today"), value: "today" },
        { name: trans("Last 7 days"), value: "last_week" },
        { name: trans("Last 30 Days"), value: "last_month" },
        { name: trans("Last 12 Month"), value: "last_year" },
    ];

    const dispatch = useDispatch();
    const { preference: { row_per_page } = {} } = usePreferences();
    const { access_token } = useAuth();
    const URL = `${BASE_API_URL_STG}/user/orders?rows_per_page=${row_per_page}`;
    const dateRef = useRef(null);
    const statusRef = useRef(null);
    const [date, setDate] = useState(dateFilter[0]);
    const [orderStatuses, setOrderStatuses] = useState([]);
    const [status, setStatus] = useState(orderStatuses[0]);
    const [inFileLoading, setInFileLoading] = useState(true);
    const { myOrders, loading, isRefresh, nextPageUrl, loadMore } = useSelector(
        (state) => state.getMyOrdersSlice
    );
    const { countries, loading: countryLoading } = useSelector(
            (state) => state.getCountries
        );

    const navigateToHome = props.route?.params?.resetToHome

    useEffect(() => {
        if (navigateToHome) {
          props.navigation.addListener('beforeRemove', e => {
            e.preventDefault();
            props.navigation.dispatch(props.navigation.navigate("Home"));
          });
        }
      }, [props.navigation, navigateToHome]);

    useEffect(() => {
        let isMounted = true;
        if (countries.length == 0 && isMounted) dispatch(getCountries(access_token));
        return () => {
            isMounted = false;
        };
    }, []);

    const onRefresh = () => {
        dispatch(getPreferences());
        dispatch(getMyOrders({ access_token, URL }));
    };

    const handleLoadMoreOrders = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreOrders({ access_token, URL: nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };

    useEffect(() => {
        (async () => {
            setInFileLoading(true);
            if (date?.value && status?.value) {
                const url = `${URL}&filter_status=${status?.value}&filter_day=${date?.value}`;
                await dispatch(getMyOrders({ access_token, URL: url }));
            } else if (date?.value && !status?.value) {
                const url = `${URL}&filter_day=${date?.value}`;
                await dispatch(getMyOrders({ access_token, URL: url }));
            } else if (!date?.value && status?.value) {
                const url = `${URL}&filter_status=${status?.value}`;
                await dispatch(getMyOrders({ access_token, URL: url }));
            } else {
                await dispatch(getMyOrders({ access_token, URL }));
            }
            setInFileLoading(false);
        })()
    }, [status, date]);

    useEffect(() => {
        const fetchOrderStatuses = async () => {
            const defaultStatus = { name: "All Status", value: "" };
            const StatusURL = `${BASE_API_URL_STG}/user/orders/statuses`;
    
            if (myOrders.length > 0) {
                const status = myOrders[0].order_statuses.map((item) => ({
                    name: item.name,
                    value: item.slug
                }));
                setOrderStatuses([defaultStatus, ...status]);
            } else {
                try {
                    const response = await dispatch(getAllOrderStatus({ URL: StatusURL }));
                    const {
                        records: returnStatusData,
                    } = response?.payload;
                    const status = returnStatusData?.data?.map((item) => ({
                        name: item.name,
                        value: item.slug
                    }));
                    setOrderStatuses([defaultStatus, ...status]);
                } catch (error) {}
            }
        };
    
        fetchOrderStatuses();
    }, [myOrders]);

    const [loadBtmSheet, setLoadBtmSheet] = useState(false);
    useEffect(() => {
        setLoadBtmSheet(true);
    }, []);

    const memoizeOrder = useMemo(
        () =>
            ({ item, index }) =>
                <SingleOrder item={item} index={index} />,
        []
    );

    let content = null;
    if (inFileLoading || countryLoading) {
        content = <OrderHistorySkeleton />;
    }
    if (!inFileLoading && myOrders.length === 0) {
        content = (
            <FlatList
                style={orderHistoryStyle.mt20}
                refreshing={isRefresh}
                onRefresh={onRefresh}
                showsVerticalScrollIndicator={false}
                ListHeaderComponent={() => (
                    <EmptyContent
                        Icon={NoContentIcon}
                        text={trans("No Order Available")}
                    />
                )}
            />
        );
    }
    if (!inFileLoading && myOrders.length > 0) {
        content = (
            <FlatList
                data={myOrders}
                keyExtractor={(_, i) => "key" + i}
                renderItem={memoizeOrder}
                showsVerticalScrollIndicator={false}
                refreshing={false}
                onRefresh={onRefresh}
                initialNumToRender={10}
                windowSize={10}
                onEndReachedThreshold={0.5}
                onEndReached={handleLoadMoreOrders}
            />
        );
    }
    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("order history")}
                capitalize={false}
            />
            <View style={ProfileStyles.hrLine} />
            <View style={orderHistoryStyle.itemsContainer}>
                <View style={orderHistoryStyle.filterCont}>
                    <Text style={orderHistoryStyle.filterText} numberOfLines={1}>
                        {txtSliceFmt(trans("Filter By"), 10)}
                    </Text>
                    <SelectInput
                        style={orderHistoryStyle.orderSelectInputCont}
                        placeholder={trans("All Time")}
                        onPress={() => dateRef.current?.snapToIndex(0)}
                        title={trans(date?.name)}
                        icon={<CustomSVG svgIcon={DownArrowFill} fill={"#2C2C2C"} />}
                    />
                    <SelectInput
                        style={orderHistoryStyle.orderSelectInputCont}
                        placeholder={trans("All Status")}
                        onPress={() => statusRef.current?.snapToIndex(0)}
                        title={trans(status?.name)}
                        icon={<CustomSVG svgIcon={DownArrowFill} fill={"#2C2C2C"} />}
                    />
                </View>
                {content}
            </View>
            {loadMore && <CustomActiveIndicator />}
            {loadBtmSheet && (
                <>
                    <SelectItemBottomSheet
                        snapPoint={[300]}
                        selectRef={dateRef}
                        data={dateFilter}
                        name={"Time"}
                        onPress={setDate}
                    />
                    {orderStatuses.length > 0 && 
                        <SelectItemBottomSheet
                            snapPoint={[300]}
                            selectRef={statusRef}
                            data={orderStatuses}
                            name={"Status"}
                            onPress={setStatus}
                        />
                    }
                </>
            )}
        </>
    );
};

export default OrderHistory;
